<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Activity extends Model 
{

    protected $table = 'activities';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function locations()
    {
        return $this->hasManyThrough('App\Models\Location', 'App\Models\LocationActivity');
    }

}